<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

include 'include/head.php';
include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            Liste des notes (cliquez sur la note pour la changer)
                        </div>
                        <!-- /.panel-heading -->
                        <div class="panel-body">
                            <div class="dataTable_wrapper">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                    <thead>
                                    <tr>
                                        <th>Cours</th>
                                        <th>Nom</th>
                                        <th>Prénom</th>
                                        <th>Epreuve</th>
                                        <th>Note</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    if (isset($_SESSION['id_prof'])) {
                                        $requete2 = $bdd->prepare("SELECT note, note.id AS noteid, cours.id_cours, id_note_cours, id_eleve4, prenom, nom, type_note, coefficient, nom_cours FROM eleve, coefficient, groupe_eleve, cours, note, enseigne_le_cours WHERE groupe_eleve.id_eleve4=eleve.id_eleve AND cours.id_groupe2=groupe_eleve.id_groupe AND note.eleve_id=eleve.id_eleve AND note.note_id=coefficient.id_note_cours AND coefficient.id_cours3=cours.id_cours AND enseigne_le_cours.id_cours=cours.id_cours AND id_professeur=:id_prof");
                                        $requete2->bindParam(':id_prof', $_SESSION['id_prof']);
                                    } else {
                                        $requete2 = $bdd->prepare("SELECT note, note.id AS noteid, id_cours, id_note_cours, id_eleve4, prenom, nom, type_note, coefficient, nom_cours FROM eleve, coefficient, groupe_eleve, cours, note WHERE groupe_eleve.id_eleve4=eleve.id_eleve AND cours.id_groupe2=groupe_eleve.id_groupe AND note.eleve_id=eleve.id_eleve AND note.note_id=coefficient.id_note_cours AND coefficient.id_cours3=cours.id_cours");
                                    }
                                    $requete2->execute();
                                    while ($note = $requete2->fetch())
                                    {
                                        ?>
                                        <tr>
                                            <td><a href="edition-cours.php?id=<?php echo htmlspecialchars($note['id_cours']) ?>"><?php echo htmlspecialchars($note['nom_cours']) ?></a></td>
                                            <td><?php echo htmlspecialchars($note['nom']) ?></td>
                                            <td><?php echo htmlspecialchars($note['prenom']) ?></td>
                                            <td><?php echo htmlspecialchars($note['type_note'] . ' : ' . $note['coefficient']) ?></td>
                                            <td><a href="edition-note.php?cours_id=<?php echo htmlspecialchars($note['id_cours']) ?>&note_id=<?php echo htmlspecialchars($note['id_note_cours']) ?>&note=<?php echo htmlspecialchars($note['noteid']) ?>"><?php echo htmlspecialchars($note['note']) ?></a></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.panel-body -->
                    </div>
                    <!-- /.panel -->
                </div>
                <!-- /.col-lg-12 -->
            </div>
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
